
% This code reproduces Figure 5 in the paper:
% van Loon, Olmos-Solis, Fahrenfort & Olivers (submitted): Current and future goals are represented in opposite patterns in object-selective cortex  

% Katya Olmos Solis, 2018
% katya.olmos@gmail.com

% Here we Plot the RDMs,Scaling plots and dissimilarity plots


%% Preparing paths
clear all; close all; clc
homedir =('Z:\fMRIDropProsp\');
matrices=[homedir  'Results' filesep 'FinalMatrices'];
graphs=[homedir filesep 'Results' filesep  'graphs' filesep];
addpath([homedir 'matlab_scripts']);



%% Plot mean RDM Delay, Search1, Search2 
load([matrices 'PDRDMAvgTR']);
load([matrices 'CPRDMAvgTR']);
load([matrices 'CDRDMAvgTR']);
load([matrices filesep 'colourScheme']);

periods=fields(CPRDMAvgTR);
conditionColours = kron([1 0 0; 0.5 0 0; 0 1 0; 0 .5 0; 0 0 1; 0 0 0.5], ones(4,1));
convexHulls = [ones(1,4) 2*ones(1,4) 3*ones(1,4) 4*ones(1,4) 5*ones(1,4) 6*ones(1,4)];
ma= {'d'  'o'  's' '^'}; 

CurrC = [101 50 152]/255;
CurrD = [0 153 102]/255;
CurrS = [247 148 30]/255;

ProsC = [149 121 182]/255;
ProsD = [185 217 137]/255;
ProsS = [253 208 158]/255;

DropC = [149 161 198]/255;
DropD = [185 248 204]/255;
DropS = [255 238 216]/255;
white = [255 255 255]/255;
categories=1:6;
for iRelevance = 1:3       
    figure 
    hold on
    if iRelevance == 1 %Current vs Prospective
        nP = 3;
        RDMAvgTR = CPRDMAvgTR;
        meanscalingAvg= NaN(24,2,3);
        colorMark = {[CurrC], [CurrD], [CurrS], [ProsC], [ProsD], [ProsS]};
        colorMarkE = {[CurrC], [CurrD], [CurrS], [ProsC], [ProsD], [ProsS]};
        colorLine = {[CurrC], [CurrD], [CurrS], [ProsC], [ProsD], [ProsS]};
        lineT = {'-'  '-'  '-'  ':'  ':'  ':' };
    elseif  iRelevance == 2
        nP = 2;
        RDMAvgTR = CDRDMAvgTR;
        meanscalingAvg= NaN(24,2,2);
        colorMark = {[CurrC], [CurrD], [CurrS], [white], [white], [white]};
        colorMarkE = {[CurrC], [CurrD], [CurrS],[CurrC], [CurrD], [CurrS]};
        lineT = {'-'  '-'  '-'  '--'  '--'  '--' };
        colorLine = {[CurrC], [CurrD], [CurrS], [CurrC], [CurrD], [CurrS]};
    elseif  iRelevance == 3
        nP = 2;
        RDMAvgTR = PDRDMAvgTR;
        meanscalingAvg= NaN(24,2,2);
        colorMark = {[ProsC], [ProsD], [ProsS], [white],[white],[white]};
        colorMarkE = {[ProsC], [ProsD], [ProsS],[CurrC], [CurrD], [CurrS]};
        lineT = { ':'  ':'  ':' '--'  '--'  '--' };
        colorLine = {[ProsC], [ProsD], [ProsS], [CurrC], [CurrD], [CurrS]};
        
    end

    countP = 0;

    for P=1:nP
        countP = countP +1;
        subplot(2,3, countP)
        RDM=squeeze(nanmean(RDMAvgTR.(periods{P}),1));
        RDM(isnan(RDM)) = [];
        mRDM=squareform(RDM);  
        imagesc(mRDM,[0 1]);
        Y = mdscale(mRDM,2, 'criterion','metricsstress','options', struct('MaxIter', 1000));
        meanscalingAvg(1:size(Y,1),:,P)=Y;
        alpha = ~isnan(mRDM);
        image(scale01(rankTransform_equalsStayEqual(mRDM,1)),'CDataMapping','scaled','AlphaData',alpha);
        set(gca,'CLim',[0 1],'CLimMode','manual');
        colormap(gca, colourScheme);
        set(gca,'XTick',[],'YTick',[]);
        if iRelevance == 1
            title(['Current vs Prosp-' periods{P}])
        elseif iRelevance == 2
            title(['Current vs Drop-' periods{P}])
        elseif iRelevance == 3
            title(['Prosp vs Drop-' periods{P}])
        end    
        pbaspect([1 1 1])
    end
  
    % Plot Multidimentional scaling for Current and Prospective
    countP = 3;
    for P=1:size(meanscalingAvg,3) % Delay, Search1, Search2
       % figure %('visible','off')
        %hold on
        countP = countP +1;
        subplot(2,3, countP)
        hold on
        clear Y;
        Y=meanscalingAvg(:,:,P);
        axis('square')
        inedx=~isnan(Y(:,1));
        Y=Y(inedx,:); 
        markerO = 1; 
        numbO =1;
        for icon = 1:24 
             plot(Y(icon,1), Y(icon,2),ma{numbO},'MarkerFaceColor',colorMark{markerO},'MarkerEdgeColor',colorMarkE{markerO},'MarkerSize', 8, 'LineWidth', 0.5); 
             if mod(icon,4) == 0
                markerO = markerO + 1;  
             end
  
            if mod(icon,4) == 0
                  numbO = 1; 
            else
                  numbO = numbO + 1; 
            end
             
        end

        for hullI = 1:6
            thisHullLabel = categories(hullI);
            withinHullPointIs = find(convexHulls == thisHullLabel);
            withinHullPointCoords = Y(withinHullPointIs, :);
            hullBoundaryPointIs = convhull(withinHullPointCoords(:,1), withinHullPointCoords(:,2));
            %plot(withinHullPointCoords(hullBoundaryPointIs, 1), withinHullPointCoords(hullBoundaryPointIs, 2), 'LineStyle', lineT{hullI}, 'LineWidth', linethicknes(hullI), 'Color', colorMark{hullI});
            plot(withinHullPointCoords(hullBoundaryPointIs, 1), withinHullPointCoords(hullBoundaryPointIs, 2), 'LineWidth', 2, 'Color', colorLine{hullI},'LineStyle', lineT{hullI});
        end%
     %pbaspect([1 1 1])
     maxYX = 0.5; %For Figure 3B
     set(gca, 'Ylim', [-maxYX maxYX])
     set(gca, 'Xlim', [-maxYX maxYX])
     set(gca, 'Xtick', [])
     set(gca, 'Ytick', [])
     box on
     if iRelevance == 1
            title(['Current vs Prosp-' periods{P}])
        elseif iRelevance == 2
            title(['Current vs Drop-' periods{P}])
        elseif iRelevance == 3
            title(['Prosp vs Drop-' periods{P}])
     end   

    end %period

     if iRelevance == 1
          print('-dpdf','-r600', [homedir 'Results' filesep 'graphs' filesep 'RDMMDS_CP']);
        elseif iRelevance == 2
           print('-dpdf','-r600', [homedir 'Results' filesep 'graphs' filesep 'RDMMDS_CD']);
        elseif iRelevance == 3
          print('-dpdf','-r600', [homedir 'Results' filesep 'graphs' filesep 'RDMMDS_PD']); 
     end 

end



%%  Dissimilarity Plots

load([matrices filesep 'CurrvsPropsDiss']);
load([matrices filesep  'CurrvsDropDiss']); 
load([matrices filesep 'PropsvsDropDiss']);

CurrvsPropsDiss=CurrvsPropsDiss(:,:,1:2);
CurrvsDropDiss=CurrvsDropDiss(:,:,1:2);
PropsvsDropDiss=PropsvsDropDiss(:,:,1:2);

CP=reshape(CurrvsPropsDiss,[size(CurrvsPropsDiss,1),6]);
CD=reshape(CurrvsDropDiss,[size(CurrvsDropDiss,1),6]);
PD=reshape(PropsvsDropDiss,[size(PropsvsDropDiss,1),6]);

for iRelevance = 1:3
    figure 
    if iRelevance == 1
       DissDiffRelevance=sortrows(CP);
    elseif iRelevance == 2
       DissDiffRelevance=sortrows(CD);
    elseif iRelevance == 3
       DissDiffRelevance=sortrows(PD);
    end
    
    %DissDiffRelevance=sortrows(currvsPropsDiss);
    nSubjects = size(DissDiffRelevance,1);
    meanDissDiffRelevance = mean(DissDiffRelevance,1);
    %figure
    placeJ =  [1,2,4,5,7,8];
    index=[1,4,2,5,3,6]
    for i = 1:length(meanDissDiffRelevance);
        
        h = bar(placeJ(i),meanDissDiffRelevance(index(i)), 'BarWidth', 0.7,'FaceColor', 'none');
        if i == 1, hold on, end
        if  mod(i,2) == 1; %Same Category
            col = [165 165 165]/255;
        else  mod(i,2) == 0; %Different Category
            col = [255 255 255]/255; 
        end 
        set(h, 'FaceColor', col)
    end
    
 
    DissDiffRelevanceS = sortrows(DissDiffRelevance);
    DissDiffRelevance2(:,1:2)=(DissDiffRelevanceS(:,[1,4]));
    DissDiffRelevance2(:,3) = NaN;
    DissDiffRelevance2(:,4:5)=(DissDiffRelevanceS(:,[2,5]));
    DissDiffRelevance2(:,6) = NaN;
    DissDiffRelevance2(:,7:8)=(DissDiffRelevanceS(:,[3,6]));

    plotSpreadAnoukCol(DissDiffRelevance2,[],[],{'DelayS','DelayD','', 'Search 1S','Search 1D','','Search 2S','Search 2D'}, 'showMM', 10,'nSubjects',nSubjects)
    set(gca, 'ylim', [0.3 1.1]) 
    box off
    
    if iRelevance == 1
       title(['Current vs Prosp']) 
       print('-dpdf','-r600', [homedir 'Results' filesep 'graphs' filesep 'Diss_CP']); 
    elseif iRelevance == 2
       title(['Current vs Drop']) 
       print('-dpdf','-r600', [homedir 'Results' filesep 'graphs' filesep 'Diss_CD']); 
    elseif iRelevance == 3
       title(['Prosp vs Drop']) 
       print('-dpdf','-r600', [homedir 'Results' filesep 'graphs' filesep 'Diss_PD']); 
    end
    
end %iRelevance   


